function [wheelSpd, wheelTrq, vehPrf, whPrf] = vehDynamicsModel(vehSpd, vehAcc, vehSlope, body, wh)

%% Vehicle longitudinal dynamics
% Tractive Force (N)
switch body.resForceMethod
    case "roadload"
        rollForce = ( body.f0 + body.f1 .* vehSpd ) .* cos(vehSlope);
        gradeForce = body.mass * 9.81 * sin(vehSlope);
        dragForce = body.f2 .* vehSpd.^2;

    case "analytic"
        rollForce = ( body.rollResCoeff0 + body.rollResCoeff1 .* vehSpd ) .* ( body.mass * 9.81 * cos(vehSlope) );
        gradeForce = body.mass * 9.81 * sin(vehSlope);
        dragForce = 0.5 * 1.2 * body.CdA(vehSpd) .* vehSpd.^2;
end
vehResForce = rollForce + gradeForce + dragForce;
vehInertiaForce = body.mass .* vehAcc;
vehForce = (vehSpd~=0) .* ( vehResForce + vehInertiaForce );

%% Wheels
% Wheel speed (rad/s)
wheelSpd  = vehSpd ./ wh.radius;
% Wheel torque (Nm)
wheelTrq = vehForce .* wh.radius;

%% Pack additional outputs
vehPrf.vehSpd = vehSpd;
vehPrf.vehAcc = vehAcc;
vehPrf.vehSlope = vehSlope;
vehPrf.rollForce = rollForce;
vehPrf.gradeForce = gradeForce;
vehPrf.dragForce = dragForce;
vehPrf.inertiaForce = vehInertiaForce;
vehPrf.vehForce = vehForce;
vehPrf.vehSpd = vehSpd;
whPrf.wheelSpd = wheelSpd;
whPrf.wheelTrq = wheelTrq;
